import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 8))

# Define colors for ingredients
ingredient1_color = 'red'
ingredient2_color = 'blue'
clean_empty_color = 'white'

# Define positions for objects
shot_positions = [(1, 7), (4, 7), (7, 7)]
shaker_position = (4, 3)
dispenser_positions = [(1, 9), (7, 9)]
hand_positions = [(0, 1), (8, 1)]

# Add shots
for i, pos in enumerate(shot_positions):
    ax.add_patch(patches.Rectangle(pos, 1, 1, edgecolor='black', facecolor=clean_empty_color))
    ax.text(pos[0] + 0.5, pos[1] + 0.5, f'shot_{i+1}\nclean\nempty', 
            horizontalalignment='center', verticalalignment='center', fontsize=8)

# Add shaker
ax.add_patch(patches.Circle((shaker_position[0], shaker_position[1]), 0.5, edgecolor='black', facecolor=clean_empty_color))
ax.text(shaker_position[0], shaker_position[1], 'shaker_1\nclean\nempty\nl0', 
        horizontalalignment='center', verticalalignment='center', fontsize=8)

# Add dispensers
ax.add_patch(patches.Rectangle(dispenser_positions[0], 1, 1, edgecolor='black', facecolor=ingredient1_color))
ax.text(dispenser_positions[0][0] + 0.5, dispenser_positions[0][1] + 0.5, 'dispenser_1', 
        horizontalalignment='center', verticalalignment='center', fontsize=8, color='white')

ax.add_patch(patches.Rectangle(dispenser_positions[1], 1, 1, edgecolor='black', facecolor=ingredient2_color))
ax.text(dispenser_positions[1][0] + 0.5, dispenser_positions[1][1] + 0.5, 'dispenser_2', 
        horizontalalignment='center', verticalalignment='center', fontsize=8, color='white')

# Add hands
for i, pos in enumerate(hand_positions):
    ax.add_patch(patches.Rectangle(pos, 1, 1, edgecolor='black', facecolor=clean_empty_color))
    ax.text(pos[0] + 0.5, pos[1] + 0.5, f'{"left" if i == 0 else "right"}_hand\nempty', 
            horizontalalignment='center', verticalalignment='center', fontsize=8)

# Add legend
legend_elements = [
    patches.Patch(facecolor=ingredient1_color, edgecolor='black', label='ingredient1 (red)'),
    patches.Patch(facecolor=ingredient2_color, edgecolor='black', label='ingredient2 (blue)'),
    patches.Patch(facecolor=clean_empty_color, edgecolor='black', label='clean and empty')
]
ax.legend(handles=legend_elements, loc='upper right')

# Set limits and aspect
ax.set_xlim(0, 10)
ax.set_ylim(0, 10)
ax.set_aspect('equal')
ax.axis('off')

# Save the figure
plt.savefig('barman/one_shot/ini_diagram_code/attempts/attempt_40.png')
plt.show()
# VERIFICATION FAILED:
# Dispenser2 is missing from the diagram.
